 *                                                                                  ;
 *    Reading in the 1975 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam75.raw' ;
 
 data one;
 
   infile 'F:\PSID\75FAM.DAT'  lrecl=759 missover;
   INPUT
   V3801 1-3              V3802 4-7              V3803 8-9
   V3804 10-12            V3805 13-17            V3806 18
   V3807 19               V3808 20               V3809 21
   V3810 22               V3811 23               V3812 24
   V3813 25               V3814 26               V3815 27
   V3816 28               V3817 29-34            V3818 35
   V3819 36-39            V3820 40               V3821 41-44
   V3822 45               V3823 46-49            V3824 50
   V3825 51-54            V3826 55               V3827 56-59
   V3828 60               V3829 61-63            V3830 64
   V3831 65-68            V3832 69               V3833 70-73
   V3834 74               V3835 75-77            V3836 78
   V3837 79-80            V3838 81               V3839 82-86 .2
   V3840 87-91            V3841 92-95            V3842 96
   V3843 97               V3844 98-101           V3845 102
   V3846 103-106          V3847 107              V3848 108
   V3849 109-112          V3850 113              V3851 114-117
   V3852 118              V3853 119-122          V3854 123
   V3855 124              V3856 125              V3857 126
   V3858 127-131          V3859 132              V3860 133
   V3861 134              V3862 135              V3863 136-140
   V3864 141              V3865 142-146          V3866 147
   V3867 148              V3868 149              V3869 150
   V3870 151              V3871 152              V3872 153-157
   V3873 158              V3874 159-163          V3875 164
   V3876 165-169          V3877 170-174          V3878 175
   V3879 176-180          V3880 181-185          V3881 186-190
   V3882 191-195          V3883 196-200          V3884 201-205
   V3885 206              V3886 207              V3887 208
   V3888 209              V3889 210-214          V3890 215-218
   V3891 219-223          V3892 224              V3893 225-229
   V3894 230-233          V3895 234              V3896 235-239
   V3897 240-244          V3898 245-249          V3899 250-254
   V3900 255-259          V3901 260-264          V3902 265-269
   V3903 270              V3904 271              V3905 272-276
   V3906 277              V3907 278              V3908 279
   V3909 280-283          V3910 284-287          V3911 288-291
   V3912 292-295          V3913 296-299          V3914 300-303
   V3915 304-307          V3916 308-316          V3917 317-318
   V3918 319              V3919 320-322          V3920 323-324
   V3921 325-326          V3922 327              V3923 328-329
   V3924 330-331          V3925 332-333          V3926 334
   V3927 335              V3928 336              V3929 337
   V3930 338              V3931 339              V3932 340-344
   V3933 345-347          V3934 348-349          V3935 350
   V3936 351              V3937 352              V3938 353
   V3939 354              V3940 355              V3941 356
   V3942 357-358          V3943 359              V3944 360
   V3945 361              V3946 362              V3947 363
   V3948 364              V3949 365              V3950 366
   V3951 367              V3952 368              V3953 369
   V3954 370              V3955 371              V3956 372
   V3957 373              V3958 374              V3959 375
   V3960 376              V3961 377              V3962 378
   V3963 379              V3964 380              V3965 381
   V3966 382              V3967 383              V3968 384
   V3969 385-386          V3970 387              V3971 388
   V3972 389              V3973 390              V3974 391
   V3975 392              V3976 393              V3977 394
   V3978 395              V3979 396              V3980 397
   V3981 398              V3982 399              V3983 400-401
   V3984 402              V3985 403-404          V3986 405
   V3987 406              V3988 407              V3989 408
   V3990 409-410          V3991 411              V3992 412-413
   V3993 414              V3994 415-416          V3995 417
   V3996 418-419          V3997 420              V3998 421-422
   V3999 423-424          V4000 425              V4001 426-428
   V4002 429              V4003 430-432          V4004 433
   V4005 434              V4006 435              V4007 436
   V4008 437-439          V4009 440-441          V4010 442-443
   V4011 444              V4012 445              V4013 446
   V4014 447              V4015 448-449          V4016 450
   V4017 451              V4018 452              V4019 453-455
   V4020 456              V4021 457              V4022 458
   V4023 459              V4024 460-461          V4025 462
   V4026 463              V4027 464-465          V4028 466-467
   V4029 468-469          V4030 470-471          V4031 472
   V4032 473-474          V4033 475              V4034 476
   V4035 477-479          V4036 480              V4037 481-483
   V4038 484              V4039 485              V4040 486
   V4041 487              V4042 488-489          V4043 490-491
   V4044 492-493          V4045 494              V4046 495
   V4047 496-498          V4048 499              V4049 500
   V4050 501              V4051 502              V4052 503-505
   V4053 506              V4054 507              V4055 508
   V4056 509-510          V4057 511-512          V4058 513-514
   V4059 515              V4060 516-517          V4061 518
   V4062 519              V4063 520-521          V4064 522
   V4065 523              V4066 524              V4067 525
   V4068 526              V4069 527              V4070 528
   V4071 529              V4072 530              V4073 531
   V4074 532              V4075 533              V4076 534
   V4077 535              V4078 536              V4079 537
   V4080 538              V4081 539              V4082 540
   V4083 541              V4084 542              V4085 543
   V4086_1 544            V4086_2 545            V4087 546
   V4088 547              V4089 548              V4090 549
   V4091 550              V4092 551              V4093 552-553
   V4094 554              V4095 555              V4096 556
   V4097 557              V4098 558              V4099 559
   V4100 560              V4101 561              V4102 562-563
   V4103 564              V4104 565              V4105 566
   V4106 567              V4107 568              V4108 569
   V4109 570              V4110 571-572          V4111 573-574
   V4112 575-576          V4113 577              V4114 578
   V4115 579-580          V4116 581-583          V4117 584-585
   V4118 586-588          V4119 589              V4120 590
   V4121 591              V4122 592-593          V4123 594-595
   V4124 596-597          V4125 598-599          V4126 600
   V4127 601              V4128 602              V4129 603
   V4130 604              V4131 605-606          V4132 607-609
   V4133 610              V4134 611              V4135 612
   V4136 613              V4137 614              V4138 615
   V4139 616              V4140 617              V4141 618-619
   V4142 620-621          V4143 622-623          V4144 624
   V4145 625              V4146 626              V4147 627
   V4148 628              V4149 629              V4150 630
   V4151 631              V4152 632-635          V4153 636
   V4154 637-641          V4155 642              V4156 643
   V4157 644              V4158 645              V4159 646
   V4160 647              V4161 648              V4162 649
   V4163 650              V4164 651              V4165 652
   V4166 653              V4167 654              V4168 655-659
   V4169 660              V4170 661              V4171 662-665 .2
   V4172 666              V4173 667-670          V4174 671-674 .2
   V4175 675              V4176 676-679 .2       V4177 680
   V4178 681              V4179 682              V4180 683
   V4181 684              V4182 685              V4183 686
   V4184 687-688          V4185 689-690          V4186 691-695
   V4187 696              V4188 697              V4189 698
   V4190 699              V4191 700              V4192 701-702 .1
   V4193 703              V4194 704-705          V4195 706
   V4196 707              V4197 708              V4198 709
   V4199 710              V4200 711-712          V4201 713-714
   V4202 715              V4203 716              V4204 717
   V4205 718              V4206 719              V4207 720
   V4208 721              V4209 722              V4210 723
   V4211 724              V4212 725              V4213 726
   V4214 727              V4215 728              V4216 729-730
   V4217 731-733          V4218 734-735          V4219 736-737
   V4220 738-739          V4221 740-742          V4222 743-744
   V4223 745-746          V4224 747-748          V4225 749
   V4226 750              V4227 751              V4228 752
   V4229 753              V4230 754              V4231 755-758
   V4232 759;

* SAS LABEL STATEMENT;

LABEL
   V3801 = "STUDY NUMBER 768(WAVE 8)"
   V3802 = "1975 INT #        80:6-9"
   V3803 = "STATE NOW       80:10-11"
   V3804 = "COUNTY NOW      80:12-14"
   V3805 = "ST& CNTY NOW     80:10-14"
   V3806 = "LRGST PLACE/SMSA   80:16"
   V3807 = "COVERSHEET COLOR   80:18"
   V3808 = "ONCE REFUSED       80:20"
   V3809 = "PHONE INTERVIEW    80:22"
   V3810 = "CHANGE IN FU COMP  80:24"
   V3811 = "# MOVED INTO FU    80:15"
   V3812 = "REL-HD:MOVER IN    80:17"
   V3813 = "# MOVED OUT OF FU  80:19"
   V3814 = "REL-HD:MOVER OUT   80:21"
   V3815 = "75 FU COMPOSITION  80:23"
   V3816 = "QUALITY OF MATCH   80:25"
   V3817 = "HOUSE VALUE     80:26-31"
   V3818 = "ACC HOUSE VALUE    80:32"
   V3819 = "ANNUAL RENT     80:33-36"
   V3820 = "ACC ANNUAL RENT    80:37"
   V3821 = "ANNUAL RENT VAL 80:38-41"
   V3822 = "ACC ANNUAL RENT VAL80:42"
   V3823 = "HRS HD WORKED   80:43-46"
   V3824 = "ACC HRS HD WORKED  80:47"
   V3825 = "HRS HD ILL      80:48-51"
   V3826 = "ACC HRS HD ILL     80:52"
   V3827 = "HRS HD UNEMP    80:53-56"
   V3828 = "ACC HRS HD UNEM    80:57"
   V3829 = "HRS HD TRVL WK  80:58-60"
   V3830 = "ACC HRS HD TR WK   80:61"
   V3831 = "HRS WIFE WORKED 81:10-13"
   V3832 = "ACC HRS WIFE WK    81:14"
   V3833 = "HRS WIFE UNEMP  81:15-18"
   V3834 = "ACC HRS WF UNEMP   81:19"
   V3835 = "HRS WF TRVL WK  81:20-22"
   V3836 = "ACC HRS WF TR WK   81:23"
   V3837 = "# IN FU         81:24-25"
   V3838 = "# REQUIRED ROOMS   81:26"
   V3839 = "FU WKLY FOOD STD81:27-31"
   V3840 = "ANNUAL NEED STD 81:32-36"
   V3841 = "$  FOOD USED HOME81:37-40"
   V3842 = "ACC $  FOOD HOME    81:41"
   V3843 = "#TOWHOM FDSTMPGVN  81:42"
   V3844 = "$  FD STMP LASTMO81:43-46"
   V3845 = "ACC$ LASMO FD STMPS 81:47"
   V3846 = "$ SAVD LASMO FDST81:48-51"
   V3847 = "ACC$ SAVD LASMO FDST81:52"
   V3848 = "STMP SUBSIDY INCL? 81:53"
   V3849 = "$  FD STMP 1974  81:54-57"
   V3850 = "ACC $  FDSTMP 1974  81:58"
   V3851 = "$  SAVD FDST 74  81:59-62"
   V3852 = "ACC $  SAVD FD STMP 81:63"
   V3853 = "$  EATING OUT    81:64-67"
   V3854 = "ACC $  EATING OUT   81:68"
   V3855 = "#MAJOR ADULTS      81:69"
   V3856 = "BKT LABOR FARM Y   82:10"
   V3857 = "BKT LABOR BUS Y    82:11"
   V3858 = "HEAD WAGES      82:12-16"
   V3859 = "ACC HD WAGES       82:17"
   V3860 = "BKT BONUS/OVERTIME 82:18"
   V3861 = "BKT PROF PRACT,TRD 82:19"
   V3862 = "BKT LABOR ROOMER Y 82:20"
   V3863 = "HEAD LABOR Y    82:21-25"
   V3864 = "ACC HD LABOR Y     82:26"
   V3865 = "WIFE LABOR Y    82:27-31"
   V3866 = "ACC WIFE LABOR Y   82:32"
   V3867 = "BKT ASSET FARM Y   82:33"
   V3868 = "BKT ASSET BUS Y    82:34"
   V3869 = "BKT ASSET ROOMER Y 82:35"
   V3870 = "BKT RENT,INT,DIV   82:36"
   V3871 = "BKT WIFE ASSET Y   82:37"
   V3872 = "H+W TAXABLE Y   82:38-42"
   V3873 = "ACC H+W ASSET Y    82:43"
   V3874 = "$ CONTRB OUT FU  82:44-48"
   V3875 = "#DEPENDENTS H+W    82:49"
   V3876 = "H+W TAXES       82:50-54"
   V3877 = "ADC,AFDC H+W    83:10-14"
   V3878 = "ACC ADC H+W        83:15"
   V3879 = "OTH WELFARE H+W 83:16-20"
   V3880 = "SOC SECURITY H+W83:21-25"
   V3881 = "HD OTHER RETIR  83:26-30"
   V3882 = "HD UNEMP,WKMNCMP83:31-35"
   V3883 = "HD ALIMONY      83:36-40"
   V3884 = "H+W SSI         83:41-45"
   V3885 = "BKT HD HELP RELAT  83:46"
   V3886 = "BKT ANYTHING ELSE  83:47"
   V3887 = "BKT WIFE TRANSFER  83:48"
   V3888 = "ACC TRANSF EXC ADC 83:49"
   V3889 = "H+W TOT TRANSFER83:50-54"
   V3890 = "WORK HRS OTHERS 84:10-13"
   V3891 = "TAXBL Y OTHERS  84:14-18"
   V3892 = "ACC TAXBL Y OTHERS 84:19"
   V3893 = "TAXES OTHERS    84:20-24"
   V3894 = "ASSET Y OTHERS  84:25-28"
   V3895 = "ACC ASSET Y OTHERS 84:29"
   V3896 = "ADC,AFDC OTHERS 84:30-34"
   V3897 = "OTH WELF OTHERS 84:35-39"
   V3898 = "SOC SECUR OTHERS84:40-44"
   V3899 = "OTH RETIR OTHERS84:45-49"
   V3900 = "UNEMP OF OTHERS 84:50-54"
   V3901 = "ALIMONY OTHERS  84:55-59"
   V3902 = "SSI OF OTHERS   84:60-64"
   V3903 = "BKT OTR HELP-RELAT 84:65"
   V3904 = "BKT ANYTH ELSE OTH 84:66"
   V3905 = "TOT TRANSF OTHR 84:67-71"
   V3906 = "ACC TRANSF OTHRS   84:72"
   V3907 = "# OTHER Y RECRS    84:73"
   V3908 = "# OTR LABOR Y RECR 84:74"
   V3909 = "1968 ID NUMBER  85:10-13"
   V3910 = "1969 ID NUMBER  85:14-17"
   V3911 = "1970 ID NUMBER  85:18-21"
   V3912 = "1971 ID NUMBER  85:22-25"
   V3913 = "1972 ID NUMBER  85:26-29"
   V3914 = "1973 ID NUMBER  85:30-33"
   V3915 = "1974 ID NUMBER  85:34-37"
   V3916 = "IWERS SOC SEC # 85:38-46"
   V3917 = "IWERS INT #     85:47-48"
   V3918 = "DATE OF INT        85:49"
   V3919 = "LENGTH OF INT   85:50-52"
   V3920 = "# IN FU         85:53-54"
   V3921 = "AGE OF HEAD     85:55-56"
   V3922 = "SEX OF HEAD        85:57"
   V3923 = "AGE OF WIFE     85:58-59"
   V3924 = "# KIDS IN FU    85:60-61"
   V3925 = "AGE YNGST KID   85:62-63"
   V3926 = "KIDS<25 IN FU?     86:10"
   V3927 = "KIDS STOP SCHOOL?  86:11"
   V3928 = "PUB TRANS NEAR FU? 86:12"
   V3929 = "GOOD PUB TRANS?    86:13"
   V3930 = "CAR/TRUCK IN FU?   86:14"
   V3931 = "# CARS/TRUCKS IN FU86:15"
   V3932 = "# MI DRIVEN     86:16-20"
   V3933 = "NEAREST SMSA    86:21-23"
   V3934 = "DIST CNTR SMSA  86:24-25"
   V3935 = "SAT W/NEIGHBRHD?   86:26"
   V3936 = "SATISFIED W/DU?    86:27"
   V3937 = "ACTUAL # ROOMS     86:28"
   V3938 = "TYPE DWELLING UNIT 86:29"
   V3939 = "OWN/RENT           86:30"
   V3940 = "WHY NOT OWN/RENT   86:31"
   V3941 = "WTR MOVED SINCE SPG86:32"
   V3942 = "MONTH MOVED     86:33-34"
   V3943 = "WHY MOVED          86:35"
   V3944 = "WTR MIGHT MOVE     86:36"
   V3945 = "DEF/PROB MOVE?     86:37"
   V3946 = "WHY MIGHT MOVE     86:38"
   V3947 = "PLUMBING PROBS?    86:39"
   V3948 = "LG/SM PROBLEM PLMG 86:40"
   V3949 = "STRUCT DEFECTS FU? 86:41"
   V3950 = "LG/SM PROB STRUCT  86:42"
   V3951 = "LACK SEC BREAKINS? 86:43"
   V3952 = "LG/SM PROB BREAKINS86:44"
   V3953 = "VERMIN PROBS?      86:45"
   V3954 = "LG/SM PROB VERMIN  86:46"
   V3955 = "INSULATION PROBS?  86:47"
   V3956 = "LG/SM PROB INSULAT 86:48"
   V3957 = "NEAT STREETS?      86:49"
   V3958 = "LG/SM PROB NEATNESS86:50"
   V3959 = "BAD FOR KIDS?      86:51"
   V3960 = "LG/SM PROB BAD KIDS86:52"
   V3961 = "CROWDED AREA?      86:53"
   V3962 = "LG/SM PROB CROWDS  86:54"
   V3963 = "BURGL/ROBBERIES?   86:55"
   V3964 = "LG/SM PROB RIPOFF  86:56"
   V3965 = "OTR CRIMES?        86:57"
   V3966 = "LG/SM PROB OTR CRIM86:58"
   V3967 = "EMPLOYMENT STATUS  87:10"
   V3968 = "OCC-HD (E)         87:11"
   V3969 = "IND-HD (E)      87:12-13"
   V3970 = "SELF-EMP OR? (E)   87:14"
   V3971 = "EMP BY GOVT? (E)   87:15"
   V3972 = "OWN BUS INCORP?(E) 87:16"
   V3973 = "EMPLOY OTHERS?(E)  87:17"
   V3974 = "# EMPL BY HEAD(E)  87:18"
   V3975 = "EMP BY GOVT-WK OTRE87:19"
   V3976 = "OWN BUS INC-WK SLFE87:20"
   V3977 = "EMP OTRS? WK SLF-E 87:21"
   V3978 = "# EMP BY HD-WK SLFE87:22"
   V3979 = "WTR SUPERVISE (E)  87:23"
   V3980 = "# SUPERVISE   (E)  87:24"
   V3981 = "GRANT PAY/PROMO?(E)87:25"
   V3982 = "BOSS HAVE SUPER?(E)87:26"
   V3983 = "LENGTH EMPL (E) 87:27-28"
   V3984 = "LENGTH EMP-1DIGIT-E87:29"
   V3985 = "MO START JOB(E) 87:30-31"
   V3986 = "WHAT HAPND JOB(E)  87:32"
   V3987 = "JOB NOW PAY MORE?-E87:33"
   V3988 = "JOB NOW BETTER? (E)87:34"
   V3989 = "WHY JOB BETTER? (E)87:35"
   V3990 = "# WKS PD VAC(E) 87:36-37"
   V3991 = "WTR VACATION IN 74E87:38"
   V3992 = "# WKS VAC 74 (E)87:39-40"
   V3993 = "WTR ILL IN 74(E)   87:41"
   V3994 = "WKS ILL IN 74(E)87:42-43"
   V3995 = "WTR UNEMP IN 74(E) 87:44"
   V3996 = "WKS UNEMP 74 (E)87:45-46"
   V3997 = "UNEMP 1 STRETCH (E)87:47"
   V3998 = "# WKS WKD MAIN-E87:48-49"
   V3999 = "HR/WK WKD MAIN-E87:50-51"
   V4000 = "WK MORE=PD MORE?(E)87:52"
   V4001 = "HRLY WAGE-OTR(E)87:53-55"
   V4002 = "WTR HRLY WAGE REG-E87:56"
   V4003 = "HRLY WAGE REG(E)87:57-59"
   V4004 = "COMPANY RET PLAN?E 87:60"
   V4005 = "WTR XTRA JOB (E)   87:61"
   V4006 = "OCC-XTRA JOB (E)   87:62"
   V4007 = "# EXTRA JOBS (E)   87:63"
   V4008 = "PAY/HR XTRA JOBE87:64-66"
   V4009 = "WKS WKD XTRA J-E87:67-68"
   V4010 = "HR/WK WKD XTRJ-E87:69-70"
   V4011 = "COULD WRK MORE?(E) 87:71"
   V4012 = "LIKE MORE WRK? (E) 87:72"
   V4013 = "COULD WRK LESS?(E) 87:73"
   V4014 = "LIKE LESS WRK? (E) 87:74"
   V4015 = "# MI TO WRK (E) 87:75-76"
   V4016 = "MODE TRANS TO WRK-E87:77"
   V4017 = "GET NEW JOB OR? (E)87:78"
   V4018 = "OCC SOUGHT-HD   (U)88:11"
   V4019 = "PAY/HR SOUGHT(U)88:12-14"
   V4020 = "NEED TRAINING?(U)  88:15"
   V4021 = "WHAT DO FIND JOB?-U88:16"
   V4022 = "# PLAC SEEK JOB (U)88:17"
   V4023 = "OCC-PREV JOB-HD (U)88:18"
   V4024 = "IND-PREV JOB(U) 88:19-20"
   V4025 = "SUPERVISE OTRS?(U) 88:21"
   V4026 = "WHAT HAPND JOB  (U)88:22"
   V4027 = "# WKS WKD 74 (U)88:23-24"
   V4028 = "HRS/WK WKD 74(U)88:25-26"
   V4029 = "WKS ILL IN 74(U)88:27-28"
   V4030 = "WKS UNEMP    (U)88:29-30"
   V4031 = "UNEP 1 STRETCH?(U) 88:31"
   V4032 = "# MI TO WRK (U) 88:32-33"
   V4033 = "MODE TRANS TO WRK-U88:34"
   V4034 = "JOBS NOT WORTH IT?U88:35"
   V4035 = "PAY/HR BAD JOB-U88:36-38"
   V4036 = "MOVE FOR JOB? (U)  88:39"
   V4037 = "PAY/HR TO MOVE-U88:40-42"
   V4038 = "WHY NOT MOVE? (U)  88:43"
   V4039 = "WK FOR $  IN 74?(R) 88:44"
   V4040 = "WTR GO TO WRK? (R) 88:45"
   V4041 = "OCC-PREV JOB-HD (R)88:46"
   V4042 = "IND-PREV JOB (R)88:47-48"
   V4043 = "WKS WKD IN 74(R)88:49-50"
   V4044 = "HR/WK WKD 74(R) 88:51-52"
   V4045 = "MIGHT GET NEW JOB?R88:53"
   V4046 = "TYPE JOB MIGHT GETR88:54"
   V4047 = "PAY/HR SOUGHT(R)88:55-57"
   V4048 = "NEED TRAINING? (R) 88:58"
   V4049 = "WHAT DO GET JOB(R) 88:59"
   V4050 = "# PLAC LOOK JOB(R) 88:60"
   V4051 = "JOBS NOT WORTH IT?R88:61"
   V4052 = "PAY/HR BAD JOB-R88:62-64"
   V4053 = "MAR STATUS         89:10"
   V4054 = "WTR WF WKD         89:11"
   V4055 = "OCC-WF             89:12"
   V4056 = "IND-WF          89:13-14"
   V4057 = "# WKS WKD-WF    89:15-16"
   V4058 = "HR/WK WKD-WF    89:17-18"
   V4059 = "WTR UNEMP-WF       89:19"
   V4060 = "WKS UNEMP-WF    89:20-21"
   V4061 = "COULD WRK MORE?-WF 89:22"
   V4062 = "LIKE MORE WRK?-WF  89:23"
   V4063 = "# MI TO WRK-WF  89:24-25"
   V4064 = "MODE TRANS TO WRK-W89:26"
   V4065 = "BKT TOT $  FARM RCTS89:28"
   V4066 = "WTR OWN BUS?       89:29"
   V4067 = "WTR OWN BUS INC    89:30"
   V4068 = "WTR ADC,WELF INC   89:31"
   V4069 = "WTR ADC WAS SSI    89:32"
   V4070 = "WTR SOC SEC INC    89:33"
   V4071 = "WTR SOC SEC WAS SSI89:34"
   V4072 = "OTRS W/INCOME?     89:35"
   V4073 = "WTR OTRS HAD SSI   89:36"
   V4074 = "WTR LUMP SUM PYTS  89:37"
   V4075 = "BKT $  LUMP SUM PYT 89:38"
   V4076 = "WTR OUTSIDE DEPS   89:39"
   V4077 = "# OUTSIDE DEPS     89:40"
   V4078 = "WTR DEP>HALF SUPPRT89:41"
   V4079 = "# DEP>HALF SUPPORT 89:42"
   V4080 = "WTR SAVINGS        89:43"
   V4081 = "WTR SVGS>2 MO Y    89:44"
   V4082 = "WTR HAD SVGS>2MO Y 89:45"
   V4083 = "WTR BETTER/WORSE   89:46"
   V4084 = "WHY BETTER/WORSE1ST89:47"
   V4085 = "WHY BETTER/WORSE2ND89:48"
   V4086_1 = "V284,V285 COMB  89:47-48 RESP 1"
   V4086_2 = "V284,V285 COMB  89:47-48 RESP 2"
   V4087 = "WTR LABOR UNION-HD 89:49"
   V4088 = "SURE LIFE WRK OUT? 89:50"
   V4089 = "PLAN AHEAD OR?     89:51"
   V4090 = "CARRY OUT PLANS OR?89:52"
   V4091 = "FINISH THINGS OR?  89:53"
   V4092 = "NOT ENUF CONTROL?  89:54"
   V4093 = "EDUCATION-HD    89:55-56"
   V4094 = "WTR OTR TRAINING-HD89:57"
   V4095 = "WHAT OTR TRNG-HD   89:58"
   V4096 = "TROUBLE READING?-HD89:59"
   V4097 = "WTR OTR SCHOOLING-H89:60"
   V4098 = "WHAT OTR SCHLNG-HD 89:61"
   V4099 = "WTR DEGREE-HD      89:62"
   V4100 = "WTR ADVANCED DEG-HD89:63"
   V4101 = "WTR WIFE IN FU     89:64"
   V4102 = "EDUCATION-WF    89:65-66"
   V4103 = "WTR OTR SCHLNG-WF  89:67"
   V4104 = "WHAT OTR SCHLNG-WF 89:68"
   V4105 = "WTR DEGREE-WF      89:69"
   V4106 = "WTR ADVANCED DEG-WF89:70"
   V4107 = "WTR NEW WIFE       90:10"
   V4108 = "EDUC-WF FATHER     90:11"
   V4109 = "EDUC-WF MOTHER     90:12"
   V4110 = "# YRS WF WKD $   90:13-14"
   V4111 = "# YRS WF WKD FUL90:15-16"
   V4112 = "P TIME WF WKD   90:17-18"
   V4113 = "ACC P TIME WF WKD  90:19"
   V4114 = "WTR NEW HEAD       90:20"
   V4115 = "ST GREW UP-FA HD90:21-22"
   V4116 = "CO GREW UP-FA HD90:23-25"
   V4117 = "ST GREW UP-MO HD90:26-27"
   V4118 = "CO GREW UP-MO HD90:28-30"
   V4119 = "OCC-HDS FA         90:31"
   V4120 = "OCC-HDS FIRST JOB  90:32"
   V4121 = "# DIFF JOBS OR?    90:33"
   V4122 = "AGE HDS 1ST KID 90:34-35"
   V4123 = "AGE HDS 2ND KID 90:36-37"
   V4124 = "AGE HDS 3RD KID 90:38-39"
   V4125 = "# OF KIDS OF HD 90:40-41"
   V4126 = "# KIDS HEAD BY 25  90:42"
   V4127 = "# SIBLINGS OF HD   90:43"
   V4128 = "WTR OLDER SIBLINGS 90:44"
   V4129 = "RELIGIOUS PREFERENC90:45"
   V4130 = "WTR HD GREW UP FARM90:46"
   V4131 = "ST HD GREW UP   90:47-48"
   V4132 = "CO HD GREW UP   90:49-51"
   V4133 = "# REGIONS LIVD IN  90:52"
   V4134 = "# STATES LIVED IN  90:53"
   V4135 = "EVER MOVED FOR JOB?90:54"
   V4136 = "REFUSE DISTANT JOB?90:55"
   V4137 = "PARENTS POOR OR?   90:56"
   V4138 = "EDUC-HDS FA        90:57"
   V4139 = "EDUC-HDS MO        90:58"
   V4140 = "WTR VETERAN        90:59"
   V4141 = "# YRS WKD>18-HD 90:60-61"
   V4142 = "# YRS WKD FULL-H90:62-63"
   V4143 = "P TIME WKD-HD   90:64-65"
   V4144 = "ACC P TIME WKD-HD  90:66"
   V4145 = "WTR BAD HEALTH     90:67"
   V4146 = "WTR HLTH LIMITS WRK90:68"
   V4147 = "HOW LONG LIMITED   90:69"
   V4148 = "WTR HLTH BETTER OR 90:70"
   V4149 = "WHO RESPONDENT?    90:71"
   V4150 = "# CALLS BY IWER    90:72"
   V4151 = "DIST TO CNTR CITY 5V351"
   V4152 = "YRLY PROPRTY TAXES 5V352"
   V4153 = "HOUSE VALUE BKT    5V353"
   V4154 = "TOT FU MON INC     5V354"
   V4155 = "TOT FU MON INC BKT 5V355"
   V4156 = "HD TOT LABOR Y BKT 5V356"
   V4157 = "WF TOT LABOR Y BKT 5V357"
   V4158 = "TOT TAX Y H+W BKT  5V358"
   V4159 = "TOT TAX Y-OTHR BKT 5V359"
   V4160 = "H+W ADC-AFDC BKT   5V360"
   V4161 = "H+W OTHER WELF BKT 5V361"
   V4162 = "H+W SOC SECUR BKT  5V362"
   V4163 = "HD OTHER RETIR BKT 5V363"
   V4164 = "HD UNEMPLOYMNT BKT 5V364"
   V4165 = "HD ALIMONY BKT     5V365"
   V4166 = "HD SUPP SECUR BKT  5V366"
   V4167 = "H+W TOT TRNS Y BKT 5V367"
   V4168 = "H+W MISC TRANSFERS 5V368"
   V4169 = "H+W MISC TRANS BKT 5V369"
   V4170 = "TOT TRNS Y-OTR BKT 5V370"
   V4171 = "MONEY Y/NEEDS      5V371"
   V4172 = "MONEY Y/NEEDS BKT  5V372"
   V4173 = "ANNUAL FOOD STD    5V373"
   V4174 = "HDS AVG HRLY EARN  5V374"
   V4175 = "BKT HD AVG HR EARN 5V375"
   V4176 = "WIFE AVG HRLY EARN 5V376"
   V4177 = "BKT WF AVG HR EARN 5V377"
   V4178 = "CURRENT REGION     5V378"
   V4179 = "REGION HD GREW UP  5V379"
   V4180 = "REGION DAD GREW UP 5V380"
   V4181 = "REGION MOM GREW UP 5V381"
   V4182 = "GEOGRAPH MOBILITY  5V382"
   V4183 = "ACCURACY MONEY Y   5V383"
   V4184 = "# MINOR ASSIGNMENT 5V384"
   V4185 = "# MAJOR ASSIGNMENT 5V385"
   V4186 = "VALUE PER ROOM     5V386"
   V4187 = "BKT VALUE PER ROOM 5V387"
   V4188 = "BKT HR WAGE OV-TIM 5V388"
   V4189 = "BKT REG HRLY WAGE  5V389"
   V4190 = "BKT HR WAGE 2ND JB 5V390"
   V4191 = "BKT ACTL-REQD ROOM 5V391"
   V4192 = "PERSONS PER ROOM   5V392"
   V4193 = "BKT PERSONS/ROOM   5V393"
   V4194 = "NUMBER OF ADULTS   5V394"
   V4195 = "ONE DIGIT FAM SIZE 5V395"
   V4196 = "BKT AGE OF HEAD    5V396"
   V4197 = "BKT AGE OF WIFE    5V397"
   V4198 = "HEAD EDUCATION BKT 5V398"
   V4199 = "WIFE EDUCATION BKT 5V399"
   V4200 = "HOUSING QUALITY    5V400"
   V4201 = "NEIGHBRHD QUALITY  5V401"
   V4202 = "DECILE TOT FU Y    5V402"
   V4203 = "DECILE Y/NEEDS     5V403"
   V4204 = "RACE               5V404"
   V4205 = "SPLIT SAMPLE VAR   5V405"
   V4206 = "8 YR FAM COMP CHNG 5V406"
   V4207 = "# CHILDREN AGE 1-2 5V407"
   V4208 = "# CHILDREN AGE 3-5 5V408"
   V4209 = "# CHILD AGE 6-13   5V409"
   V4210 = "# FEMALE AGE 14-17 5V410"
   V4211 = "# MALE AGE 14-17   5V411"
   V4212 = "# FEMALE AGE 18-20 5V412"
   V4213 = "# MALE AGE 18-20   5V413"
   V4214 = "# FEMALE AGE 21-29 5V414"
   V4215 = "# MALE AGE 21-29   5V415"
   V4216 = "COLLEGE AV ACT-HD  5V415"
   V4217 = "COLL EXP/STDNT-HD  5V416"
   V4218 = "COLL PREWW2 RTNG-H 5V417"
   V4219 = "COLL POSTWW2 RTG-H 5V418"
   V4220 = "COLLEGE AV ACT-WF  5V419"
   V4221 = "COLL EXP/STDNT-WF  5V420"
   V4222 = "COLL PREWW2 RTNG-W 5V421"
   V4223 = "COLL POSTWW2 RTG-W 5V422"
   V4224 = "1975 FAMILY WEIGHT"
   V4225 = "UNSKILLED MALE     5V425"
   V4226 = "COMP FEMALE/MALE   5V426"
   V4227 = "COMP WHITE/NONWHIT 5V427"
   V4228 = "UNSKILLD MALE WAGE 5V428"
   V4229 = "COMP UNSKILLED M/F 5V429"
   V4230 = "UNEMPLOYMENT RATE  5V430"
   V4231 = "HOUSEHOLD ID # 75"
   V4232 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V3803=99 THEN V3803=.;
IF V3804=999 THEN V3804=.;
IF V3805=99999 THEN V3805=.;
IF V3806=9 THEN V3806=.;
IF V3808=9 THEN V3808=.;
IF V3809=9 THEN V3809=.;
IF V3812=9 THEN V3812=.;
IF V3814=9 THEN V3814=.;
IF V3856=9 THEN V3856=.;
IF V3857=9 THEN V3857=.;
IF V3860=9 THEN V3860=.;
IF V3861=9 THEN V3861=.;
IF V3862=9 THEN V3862=.;
IF V3867=9 THEN V3867=.;
IF V3868=9 THEN V3868=.;
IF V3869=9 THEN V3869=.;
IF V3870=9 THEN V3870=.;
IF V3871=9 THEN V3871=.;
IF V3874=99999 THEN V3874=.;
IF V3885=9 THEN V3885=.;
IF V3886=9 THEN V3886=.;
IF V3887=9 THEN V3887=.;
IF V3903 GE 9 THEN V3903=.;
IF V3904=9 THEN V3904=.;
IF V3918=9 THEN V3918=.;
IF V3919=999 THEN V3919=.;
IF V3921=99 THEN V3921=.;
IF V3923 GE 99 THEN V3923=.;
IF V3927 GE 9 THEN V3927=.;
IF V3928=9 THEN V3928=.;
IF V3929 GE 9 THEN V3929=.;
IF V3930=9 THEN V3930=.;
IF V3931 GE 9 THEN V3931=.;
IF V3932 GE 99999 THEN V3932=.;
IF V3933=999 THEN V3933=.;
IF V3934=99 THEN V3934=.;
IF V3935=9 THEN V3935=.;
IF V3936=9 THEN V3936=.;
IF V3937=9 THEN V3937=.;
IF V3938=9 THEN V3938=.;
IF V3940 GE 9 THEN V3940=.;
IF V3941=9 THEN V3941=.;
IF V3942 GE 99 THEN V3942=.;
IF V3943 GE 9 THEN V3943=.;
IF V3944=9 THEN V3944=.;
IF V3945 GE 9 THEN V3945=.;
IF V3946 GE 9 THEN V3946=.;
IF V3947=9 THEN V3947=.;
IF V3948 GE 9 THEN V3948=.;
IF V3949=9 THEN V3949=.;
IF V3950 GE 9 THEN V3950=.;
IF V3951=9 THEN V3951=.;
IF V3952 GE 9 THEN V3952=.;
IF V3953=9 THEN V3953=.;
IF V3954 GE 9 THEN V3954=.;
IF V3955=9 THEN V3955=.;
IF V3956 GE 9 THEN V3956=.;
IF V3957=9 THEN V3957=.;
IF V3958 GE 9 THEN V3958=.;
IF V3959=9 THEN V3959=.;
IF V3960 GE 9 THEN V3960=.;
IF V3961=9 THEN V3961=.;
IF V3962 GE 9 THEN V3962=.;
IF V3963=9 THEN V3963=.;
IF V3964 GE 9 THEN V3964=.;
IF V3965=9 THEN V3965=.;
IF V3966 GE 9 THEN V3966=.;
IF V3968 GE 9 THEN V3968=.;
IF V3969 GE 99 THEN V3969=.;
IF V3970 GE 9 THEN V3970=.;
IF V3971 GE 9 THEN V3971=.;
IF V3972 GE 9 THEN V3972=.;
IF V3973 GE 9 THEN V3973=.;
IF V3974 GE 9 THEN V3974=.;
IF V3975 GE 9 THEN V3975=.;
IF V3976 GE 9 THEN V3976=.;
IF V3977 GE 9 THEN V3977=.;
IF V3978 GE 9 THEN V3978=.;
IF V3979 GE 9 THEN V3979=.;
IF V3980 GE 9 THEN V3980=.;
IF V3981 GE 9 THEN V3981=.;
IF V3982 GE 9 THEN V3982=.;
IF V3983 GE 99 THEN V3983=.;
IF V3984 GE 9 THEN V3984=.;
IF V3985 GE 99 THEN V3985=.;
IF V3986 GE 9 THEN V3986=.;
IF V3987 GE 9 THEN V3987=.;
IF V3988 GE 9 THEN V3988=.;
IF V3989 GE 9 THEN V3989=.;
IF V3990 GE 99 THEN V3990=.;
IF V3991 GE 9 THEN V3991=.;
IF V3992 GE 99 THEN V3992=.;
IF V3993 GE 9 THEN V3993=.;
IF V3994 GE 99 THEN V3994=.;
IF V3995 GE 9 THEN V3995=.;
IF V3996 GE 99 THEN V3996=.;
IF V3997 GE 9 THEN V3997=.;
IF V3998 GE 99 THEN V3998=.;
IF V3999 GE 99 THEN V3999=.;
IF V4000 GE 9 THEN V4000=.;
IF V4001 GE 999 THEN V4001=.;
IF V4002 GE 9 THEN V4002=.;
IF V4003 GE 999 THEN V4003=.;
IF V4004 GE 9 THEN V4004=.;
IF V4005 GE 9 THEN V4005=.;
IF V4006 GE 9 THEN V4006=.;
IF V4007 GE 9 THEN V4007=.;
IF V4008 GE 999 THEN V4008=.;
IF V4009 GE 99 THEN V4009=.;
IF V4010 GE 99 THEN V4010=.;
IF V4011 GE 9 THEN V4011=.;
IF V4012 GE 9 THEN V4012=.;
IF V4013 GE 9 THEN V4013=.;
IF V4014 GE 9 THEN V4014=.;
IF V4015 GE 99 THEN V4015=.;
IF V4016 GE 9 THEN V4016=.;
IF V4017 GE 9 THEN V4017=.;
IF V4018 GE 9 THEN V4018=.;
IF V4019 GE 999 THEN V4019=.;
IF V4020 GE 9 THEN V4020=.;
IF V4021 GE 9 THEN V4021=.;
IF V4022 GE 9 THEN V4022=.;
IF V4023 GE 9 THEN V4023=.;
IF V4024 GE 99 THEN V4024=.;
IF V4025 GE 9 THEN V4025=.;
IF V4026 GE 9 THEN V4026=.;
IF V4027 GE 99 THEN V4027=.;
IF V4028 GE 99 THEN V4028=.;
IF V4029 GE 99 THEN V4029=.;
IF V4030 GE 99 THEN V4030=.;
IF V4031 GE 9 THEN V4031=.;
IF V4032 GE 99 THEN V4032=.;
IF V4033 GE 9 THEN V4033=.;
IF V4034 GE 9 THEN V4034=.;
IF V4035 GE 999 THEN V4035=.;
IF V4036 GE 9 THEN V4036=.;
IF V4037 GE 999 THEN V4037=.;
IF V4038 GE 9 THEN V4038=.;
IF V4039 GE 9 THEN V4039=.;
IF V4040 GE 9 THEN V4040=.;
IF V4041 GE 9 THEN V4041=.;
IF V4042 GE 99 THEN V4042=.;
IF V4043 GE 99 THEN V4043=.;
IF V4044 GE 99 THEN V4044=.;
IF V4045 GE 9 THEN V4045=.;
IF V4046 GE 9 THEN V4046=.;
IF V4047 GE 999 THEN V4047=.;
IF V4048 GE 9 THEN V4048=.;
IF V4049 GE 9 THEN V4049=.;
IF V4050 GE 9 THEN V4050=.;
IF V4051 GE 9 THEN V4051=.;
IF V4052 GE 999 THEN V4052=.;
IF V4053=9 THEN V4053=.;
IF V4054 GE 9 THEN V4054=.;
IF V4055 GE 9 THEN V4055=.;
IF V4056 GE 99 THEN V4056=.;
IF V4057 GE 99 THEN V4057=.;
IF V4058 GE 99 THEN V4058=.;
IF V4059 GE 9 THEN V4059=.;
IF V4060 GE 99 THEN V4060=.;
IF V4061 GE 9 THEN V4061=.;
IF V4062 GE 9 THEN V4062=.;
IF V4063 GE 99 THEN V4063=.;
IF V4064 GE 9 THEN V4064=.;
IF V4065 GE 9 THEN V4065=.;
IF V4066=9 THEN V4066=.;
IF V4067 GE 9 THEN V4067=.;
IF V4068=9 THEN V4068=.;
IF V4069 GE 9 THEN V4069=.;
IF V4071 GE 9 THEN V4071=.;
IF V4073 GE 9 THEN V4073=.;
IF V4074=9 THEN V4074=.;
IF V4075 GE 9 THEN V4075=.;
IF V4076=9 THEN V4076=.;
IF V4077 GE 9 THEN V4077=.;
IF V4078 GE 9 THEN V4078=.;
IF V4079 GE 9 THEN V4079=.;
IF V4080=9 THEN V4080=.;
IF V4081 GE 9 THEN V4081=.;
IF V4082 GE 9 THEN V4082=.;
IF V4083=8 THEN V4083=.;
IF V4083 GE 9 THEN V4083=.;
IF V4084 GE 9 THEN V4084=.;
IF V4085 GE 9 THEN V4085=.;
IF V4086_1 GE 9 THEN V4086_1=.;
IF V4086_2 GE 9 THEN V4086_2=.;
IF V4087=9 THEN V4087=.;
IF V4088=9 THEN V4088=.;
IF V4089=9 THEN V4089=.;
IF V4090=9 THEN V4090=.;
IF V4091=9 THEN V4091=.;
IF V4092=9 THEN V4092=.;
IF V4093=99 THEN V4093=.;
IF V4094 GE 9 THEN V4094=.;
IF V4095 GE 9 THEN V4095=.;
IF V4096 GE 9 THEN V4096=.;
IF V4097 GE 9 THEN V4097=.;
IF V4098 GE 9 THEN V4098=.;
IF V4099 GE 9 THEN V4099=.;
IF V4100 GE 9 THEN V4100=.;
IF V4101=9 THEN V4101=.;
IF V4102 GE 99 THEN V4102=.;
IF V4103 GE 9 THEN V4103=.;
IF V4104 GE 9 THEN V4104=.;
IF V4105 GE 9 THEN V4105=.;
IF V4106 GE 9 THEN V4106=.;
IF V4108 GE 9 THEN V4108=.;
IF V4109 GE 9 THEN V4109=.;
IF V4110 GE 99 THEN V4110=.;
IF V4111 GE 99 THEN V4111=.;
IF V4115 GE 99 THEN V4115=.;
IF V4116 GE 999 THEN V4116=.;
IF V4117 GE 99 THEN V4117=.;
IF V4118 GE 999 THEN V4118=.;
IF V4119 GE 9 THEN V4119=.;
IF V4120 GE 9 THEN V4120=.;
IF V4121 GE 9 THEN V4121=.;
IF V4122 GE 99 THEN V4122=.;
IF V4123 GE 99 THEN V4123=.;
IF V4124 GE 99 THEN V4124=.;
IF V4125 GE 99 THEN V4125=.;
IF V4126 GE 9 THEN V4126=.;
IF V4127 GE 9 THEN V4127=.;
IF V4128 GE 9 THEN V4128=.;
IF V4130 GE 9 THEN V4130=.;
IF V4131 GE 99 THEN V4131=.;
IF V4132 GE 999 THEN V4132=.;
IF V4133 GE 9 THEN V4133=.;
IF V4134 GE 9 THEN V4134=.;
IF V4135 GE 9 THEN V4135=.;
IF V4136 GE 9 THEN V4136=.;
IF V4137 GE 9 THEN V4137=.;
IF V4138 GE 9 THEN V4138=.;
IF V4139 GE 9 THEN V4139=.;
IF V4140 GE 9 THEN V4140=.;
IF V4141 GE 99 THEN V4141=.;
IF V4142 GE 99 THEN V4142=.;
IF V4145 GE 9 THEN V4145=.;
IF V4146 GE 9 THEN V4146=.;
IF V4147 GE 9 THEN V4147=.;
IF V4148 GE 9 THEN V4148=.;
IF V4149=9 THEN V4149=.;
IF V4150=9 THEN V4150=.;
IF V4151=9 THEN V4151=.;
IF V4179=9 THEN V4179=.;
IF V4180=9 THEN V4180=.;
IF V4181=9 THEN V4181=.;
IF V4182=9 THEN V4182=.;
IF V4186=99999 THEN V4186=.;
IF V4187=9 THEN V4187=.;
IF V4188=9 THEN V4188=.;
IF V4189=9 THEN V4189=.;
IF V4190=9 THEN V4190=.;
IF V4191=9 THEN V4191=.;
IF V4192=9.9 THEN V4192=.;
IF V4193=9 THEN V4193=.;
IF V4196=9 THEN V4196=.;
IF V4197=9 THEN V4197=.;
IF V4198=9 THEN V4198=.;
IF V4199=9 THEN V4199=.;
IF V4204=9 THEN V4204=.;
IF V4216=0 THEN V4216=.;
IF V4216 GE 99 THEN V4216=.;
IF V4217=0 THEN V4217=.;
IF V4217 GE 999 THEN V4217=.;
IF V4218=0 THEN V4218=.;
IF V4218 GE 99 THEN V4218=.;
IF V4219=0 THEN V4219=.;
IF V4219 GE 99 THEN V4219=.;
IF V4220=0 THEN V4220=.;
IF V4220 GE 99 THEN V4220=.;
IF V4221=0 THEN V4221=.;
IF V4221 GE 999 THEN V4221=.;
IF V4222=0 THEN V4222=.;
IF V4222 GE 99 THEN V4222=.;
IF V4223=0 THEN V4223=.;
IF V4223 GE 99 THEN V4223=.;
IF V4225=9 THEN V4225=.;
IF V4226=9 THEN V4226=.;
IF V4227=9 THEN V4227=.;
IF V4228=9 THEN V4228=.;
IF V4229=9 THEN V4229=.;
IF V4230=9 THEN V4230=.;
 
file rawdat lrecl=759;
put    
v3802
v3810
v3817
v3818
v3819
v3820
v3823
v3824
v3831
v3832
v3840
v3841
v3842
v3846
v3847
v3848
v3851
v3852
v3853
v3854
v3863
v3864
v3865
v3866
v3870
v3871
v3872
v3876
v3889
v3890
v3891
v3893
v3894
v3905
v3918
v3920
v3921
v3922
v3923
v3931
v3939
v3941
v3942
v3943
v3967
v3970
v3986
v3998
v3999
v4026
v4027
v4028
v4053
v4057
v4058
v4075
v4077
v4093
v4099
v4102
v4105
v4114
v4145
v4154
v4178
v4183
v4198
v4199
v4204
v4224
v30168
;

 proc means;
 run; 
